
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Mar 28 12:09:38 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version SST_TST_ATP_Index.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ***********************************/
#include "SST_TST.h"
#if TST_USE_INDEX_MODULE
/************************ Defines ******************************/
/************************ Enums ********************************/
/************************ Typedefs *****************************/
/************************ Global Data **************************/
/************* Private function prototype **********************/
/************************ Public Functions *********************/
/*****************************************************************************
 * Function Name:                                                           
 *  SST_TST_ATP_Index         
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 * Test the indexing services  create, bind, unbind, find and delete operations
 *  
 * Algorithm:       
 *    1.  Create a new session by calling: SST_SessionCreate.
 *    2.  Open a transaction by calling: SST_TransactionStart.
 *    3.  Create a new password authenticator by calling: SST_AuthenticatorPasswordCreate.
 *    4.  Close the transaction by calling: SST_TransactionClose.
 *    5.  Open the password authenticator by calling: SST_AuthenticationOpen.
 *    6.  Open a transaction by calling: SST_TransactionStart.
 *    7.  Insert new data objects 1~4 by calling: SST_InsertData.
 *    8.  Bind data objects with different strings (String1~4) for each object: SST_IndexLookUpBind. 
 *    9.  Bind data objects 1~4 with the same string (String5) by calling:SST_IndexLookUpBind.
 *    10.  Receive and verify all handles for String1by calling:
 *            i.  SST_IndexLookUpBegin
 *            ii.  SST_IndexLookUpHandlesGet
 *            iii.  Verify Correct handle is returned
 *            iv.  SST_IndexLookUpEnd
 *    11.  Receive and verify all handles for String2by calling:
 *            i.  SST_IndexLookUpBegin
 *            ii.  SST_IndexLookUpHandlesGet
 *            iii.  Verify Correct handle is returned
 *            iv.  SST_IndexLookUpEnd
 *    12.  Receive and verify all handles for String5by calling:
 *            i.      SST_IndexLookUpBegin
 *            ii.  SST_IndexLookUpHandlesGet
 *            iii.  Verify Correct handle is returned
 *            iv.  SST_IndexLookUpEnd
 *    13.  Unbind Object#3 from String#5 by calling: SST_IndexLookupUnbind
 *    14.  Receive and verify all handles for String5by calling:
 *            i.      SST_IndexLookUpBegin
 *            ii.  SST_IndexLookUpHandlesGet
 *            iii.  Verify Correct handle is returned
 *            iv.  SST_IndexLookUpEnd
 *    15.  Delete all lookup indexes by calling: SST_IndexLookupDelete
 *    16.  Delete all the data objects (one by one) by calling: SST_DeleteData.
 *    17.  Delete the authenticator by calling: SST_AuthenticatorDelete.
 *    18.  Close the transaction by calling: SST_TransactionClose.
 *    19.  Delete the session by calling: SST_SessionDelete.
 *
 *******************************************************************************/    
DxError_t SST_TST_ATP_Index ( void )
{
    /********* TST Variables Definitions ************/
    int                 TST_index,TST_HandleType,TST_NumberOfHandleMatch;
    char                TST_MasterTestName[TST_FUNC_STRING_LEN] = "SST_TST_ATP_Index";
    SSTSessionId_t      TST_SessionId; 
    SSTTxnId_t          TST_TransactionId;
    SSTHandle_t         TST_AuthHandle;
    SSTHandle_t         TST_DataHandle1,TST_DataHandle2,TST_DataHandle3,TST_DataHandle4;
    SSTDataType_t       TST_SimpleData = TST_DATA_OBJECT;
    DxUint32_t          TST_TempMaxHandlesToRead;
    DxUint32_t          TST_TempMaxNumOfMatches;
    SSTHandle_t         TST_AuthDefaultHandle;
    SSTIXCookie_t       TST_IterCookie;
    DxError_t           TST_Status;
    /********* TST Variables initialization *********/
  

    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************** \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," ** SST_TST_ATP_Index Tests ********************* \n"));     
    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************** \n \n"));

    /************************************************/
    /*********** Start of test **********************/
    /************************************************/

    for (TST_HandleType = TST_INTERNAL_HANDLE ; TST_HandleType < TST_HANDLES_TYPES ; TST_HandleType++)
    {
        for (TST_index =0 ; TST_index < TST_NumberOf_IndexTests ; TST_index++) /*To run on all test vectors*/
        {
            if (TST_HandleType == TST_INTERNAL_HANDLE)
            {   
                ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
                ATP_LOG_TST_PRINT((SST_TST_MSG," TEST using internal handles          \n"));
                ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
                TST_AuthHandle.objId = SST_HANDLE_RANDOM_GENERATE; 
                TST_DataHandle1.objId = SST_HANDLE_RANDOM_GENERATE;
                TST_DataHandle2.objId = SST_HANDLE_RANDOM_GENERATE;
                TST_DataHandle3.objId = SST_HANDLE_RANDOM_GENERATE;
                TST_DataHandle4.objId = SST_HANDLE_RANDOM_GENERATE;
            }
            else
            {
                ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
                ATP_LOG_TST_PRINT((SST_TST_MSG," TEST using external handles          \n"));
                ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
                TST_AuthHandle.objId  = TST_TEST_DEFINED_HENDLE_1; 
                TST_DataHandle1.objId = TST_TEST_DEFINED_HENDLE_2;
                TST_DataHandle2.objId = TST_TEST_DEFINED_HENDLE_3;
                TST_DataHandle3.objId = TST_TEST_DEFINED_HENDLE_4;
                TST_DataHandle4.objId = TST_TEST_DEFINED_HENDLE_5;
            }

            ATP_LOG_TST_PRINT((SST_TST_MSG,"\n",TST_ATP_IndexTestData[TST_index].TST_Name,"\n"));

            /* Create a session for operations */
            /*---------------------------------*/
            TST_Status = SST_SessionCreate(&TST_SessionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionCreate",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);

            /* Open a transaction for operations */
            /*-----------------------------------*/
            TST_Status = SST_TransactionStart(&TST_TransactionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Create a new password authenticator */
            /*-------------------------------------*/
            TST_AuthDefaultHandle.objDigest = 0;
      TST_AuthDefaultHandle.objId = SST_CLOSE_AUTH_HANDLE;
            TST_Status = SST_AuthenticatorPasswordCreate(TST_TransactionId,
                                                        TST_SessionId,
                                                        TST_ATP_IndexTestData[TST_index].TST_Password,
                                                        TST_ATP_IndexTestData[TST_index].TST_PasswordSizeInBytes,
                                                        TST_ATP_IndexTestData[TST_index].TST_MaxNumOfTrials,
                                                        TST_AuthDefaultHandle,
                                                        &TST_AuthHandle,
                                                        TST_Workspace,
                                                        TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorPasswordCreate",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);

            /* Close the transaction */
            /*-----------------------*/
            TST_Status = SST_TransactionEnd(TST_TransactionId,
                       DX_TRUE,/*reflash sensitive*/
                       TST_Workspace,
                                           TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Open the password authentication */
            /*---------------------------------*/
            TST_Status = SST_AuthenticationOpen(TST_SessionId,
                                               TST_AuthHandle,
                                               TST_ATP_IndexTestData[TST_index].TST_Password,
                                               TST_ATP_IndexTestData[TST_index].TST_PasswordSizeInBytes,
                                               TST_NO_CHALLENGE,
                                               TST_Workspace,
                                               TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationOpen",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);

      /* Open a transaction for operations */
            /*-----------------------------------*/
            TST_Status = SST_TransactionStart(&TST_TransactionId);
      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Insert a new Data objects 1~4 */
            /*-------------------------------*/
            /* Data1*/
            TST_Status = SST_DataInsert(TST_TransactionId,
                                       TST_SessionId, 
                                       TST_AuthHandle,       
                                       TST_ATP_IndexTestData[TST_index].TST_Data,
                                       TST_ATP_IndexTestData[TST_index].TST_DataSize,
                                       DX_TRUE,
                                       TST_SimpleData,                
                                       &TST_DataHandle1,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataInsert1",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);

            /*Data2*/
            TST_Status = SST_DataInsert(TST_TransactionId,
                                       TST_SessionId, 
                                       TST_AuthHandle,       
                                       TST_ATP_IndexTestData[TST_index].TST_Data,
                                       TST_ATP_IndexTestData[TST_index].TST_DataSize,
                                       DX_TRUE,
                                       TST_SimpleData,                
                                       &TST_DataHandle2,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataInsert2",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);

            /*Data3*/
            TST_Status = SST_DataInsert(TST_TransactionId,
                                       TST_SessionId, 
                                       TST_AuthHandle,       
                                       TST_ATP_IndexTestData[TST_index].TST_Data,
                                       TST_ATP_IndexTestData[TST_index].TST_DataSize,
                                       DX_TRUE,
                                       TST_SimpleData,                
                                       &TST_DataHandle3,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataInsert3",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);

            /*data4*/
            TST_Status = SST_DataInsert(TST_TransactionId,
                                       TST_SessionId, 
                                       TST_AuthHandle,       
                                       TST_ATP_IndexTestData[TST_index].TST_Data,
                                       TST_ATP_IndexTestData[TST_index].TST_DataSize,
                                       DX_TRUE,
                                       TST_SimpleData,                
                                       &TST_DataHandle4,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataInsert4",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);



            /*Bind data objects with different strings */
            /*-----------------------------------------*/
            /*Bind object1 string1*/
            TST_Status = SST_IndexLookupBind(TST_TransactionId,
                                            TST_SessionId,
                                            TST_DataHandle1,
                                            TST_ATP_IndexTestData[TST_index].TSTString1Size,
                                            TST_ATP_IndexTestData[TST_index].TSTString1,
                                            TST_Workspace,
                                            TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_IndexLookupBind-Index1/Object1/String1",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /*Bind object2 string2*/
            TST_Status = SST_IndexLookupBind(TST_TransactionId,
                                            TST_SessionId,
                                            TST_DataHandle2,
                                            TST_ATP_IndexTestData[TST_index].TSTString2Size,
                                            TST_ATP_IndexTestData[TST_index].TSTString2,
                                            TST_Workspace,
                                            TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_IndexLookupBind-Index1/Object2/String2",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /*Bind object3 string3*/
            TST_Status = SST_IndexLookupBind(TST_TransactionId,
                                            TST_SessionId,
                                            TST_DataHandle3,
                                            TST_ATP_IndexTestData[TST_index].TSTString3Size,
                                            TST_ATP_IndexTestData[TST_index].TSTString3,
                                            TST_Workspace,
                                            TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_IndexLookupBind-Index1/Object3/String3",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /*Bind Index1 object4 string4*/
            TST_Status = SST_IndexLookupBind(TST_TransactionId,
                                            TST_SessionId,
                                            TST_DataHandle4,
                                            TST_ATP_IndexTestData[TST_index].TSTString4Size,
                                            TST_ATP_IndexTestData[TST_index].TSTString4,
                                            TST_Workspace,
                                            TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_IndexLookupBind-Index1/Object4/String4",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /*Bind data objects with same string */
            /*-----------------------------------*/
            /*Bind object1 string5*/
            TST_Status = SST_IndexLookupBind(TST_TransactionId,
                                            TST_SessionId,
                                            TST_DataHandle1,
                                            TST_ATP_IndexTestData[TST_index].TSTString5Size,
                                            TST_ATP_IndexTestData[TST_index].TSTString5,
                                            TST_Workspace,
                                            TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_IndexLookupBind-Index2/Object1",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /*Bind object2 string5*/
            TST_Status = SST_IndexLookupBind(TST_TransactionId,
                                            TST_SessionId,
                                            TST_DataHandle2,
                                            TST_ATP_IndexTestData[TST_index].TSTString5Size,
                                            TST_ATP_IndexTestData[TST_index].TSTString5,
                                            TST_Workspace,
                                            TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_IndexLookupBind-Index2/Object2",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /*Bind object3 string5*/
            TST_Status = SST_IndexLookupBind(TST_TransactionId,
                                            TST_SessionId,
                                            TST_DataHandle3,
                                            TST_ATP_IndexTestData[TST_index].TSTString5Size,
                                            TST_ATP_IndexTestData[TST_index].TSTString5,
                                            TST_Workspace,
                                            TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_IndexLookupBind-Index2/Object3",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);
  

            /*Bind object4 string5*/
            TST_Status = SST_IndexLookupBind(TST_TransactionId,
                                            TST_SessionId,
                                            TST_DataHandle4,
                                            TST_ATP_IndexTestData[TST_index].TSTString5Size,
                                            TST_ATP_IndexTestData[TST_index].TSTString5,
                                            TST_Workspace,
                                            TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_IndexLookupBind-Index2/Object4",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);
            
            /* Receive and verify all handles for TSTString1 */
            /*-----------------------------------------------*/
            /*Begin index lookup*/
            TST_Status = SST_IndexLookUpBegin (TST_ATP_IndexTestData[TST_index].TSTString1,
                                              TST_ATP_IndexTestData[TST_index].TSTString1Size, 
                                              &TST_IterCookie);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_IndexLookUpBegin-TSTString1",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);

            TST_TempMaxHandlesToRead = TST_ATP_IndexTestData[TST_index].TST_MaxHandlesToRead1;

            TST_Status = SST_IndexLookUpHandlesGet(TST_SessionId,
                                                  &TST_IterCookie,
                                                  (SSTHandle_t*)TST_ATP_IndexTestData[TST_index].TSTRetHandles,
                                                  &TST_TempMaxHandlesToRead,
                                                  &TST_TempMaxNumOfMatches,
                                                  TST_Workspace,
                                                  TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_IndexLookUpHandlesGet - TSTString1",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Check correct read amount */
            if (TST_TempMaxHandlesToRead != TST_ATP_IndexTestData[TST_index].TST_MaxHandlesRead1)
                TST_Status = TESTFAIL;

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"Check correct read amount",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Verify Correct handle is returned */
            if ((SST_HANDLE_COMPARE(TST_ATP_IndexTestData[TST_index].TSTRetHandles[TST_HANDLE_ONE],TST_DataHandle1)))
                TST_Status = TESTFAIL;

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"Verify correct handle is returned - TSTString1",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /*End index lookup*/
            TST_Status = SST_IndexLookUpEnd (&TST_IterCookie);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_IndexLookUpEnd - TSTString1",
                                TST_ATP_IndexTestData[TST_index].TST_Name,
                                TST_MasterTestName);




            /* Receive and verify all handles for TSTString2 */
            /*-----------------------------------------------*/
            /*Begin index lookup*/
            TST_Status = SST_IndexLookUpBegin (TST_ATP_IndexTestData[TST_index].TSTString2,
                                              TST_ATP_IndexTestData[TST_index].TSTString2Size,
                                              &TST_IterCookie);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_IndexLookUpBegin-TSTString2",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            TST_TempMaxHandlesToRead = TST_ATP_IndexTestData[TST_index].TST_MaxHandlesToRead2; 

            TST_Status = SST_IndexLookUpHandlesGet(TST_SessionId,
                                                  &TST_IterCookie,
                                                  (SSTHandle_t*)TST_ATP_IndexTestData[TST_index].TSTRetHandles,
                                                  &TST_TempMaxHandlesToRead,
                                                  &TST_TempMaxNumOfMatches,
                                                  TST_Workspace,
                                                  TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_IndexLookUpHandlesGet - TSTString2",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);

            /* Check correct read amount */
            if (TST_TempMaxHandlesToRead != TST_ATP_IndexTestData[TST_index].TST_MaxHandlesRead2)
                TST_Status = TESTFAIL;

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"Check correct read amount",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Verify Correct handle is returned */
            if ((SST_HANDLE_COMPARE(TST_ATP_IndexTestData[TST_index].TSTRetHandles[TST_HANDLE_ONE],TST_DataHandle2)))
                TST_Status = TESTFAIL;

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"Verify Only one handle is returned - TSTString2",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);

            
            /*End index lookup*/
            TST_Status = SST_IndexLookUpEnd (&TST_IterCookie);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_IndexLookUpEnd - TSTString2",
                                TST_ATP_IndexTestData[TST_index].TST_Name,
                                TST_MasterTestName);



            /* Receive and verify all handles for TSTString5 */
            /*-----------------------------------------------*/
            /*Begin index lookup*/
            TST_Status = SST_IndexLookUpBegin (TST_ATP_IndexTestData[TST_index].TSTString5,
                                              TST_ATP_IndexTestData[TST_index].TSTString5Size, 
                                              &TST_IterCookie);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_IndexLookUpBegin-TSTString5",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);

            TST_TempMaxHandlesToRead = TST_ATP_IndexTestData[TST_index].TST_MaxHandlesToRead3; 

            TST_Status = SST_IndexLookUpHandlesGet(TST_SessionId,
                                                  &TST_IterCookie,
                                                  (SSTHandle_t*)TST_ATP_IndexTestData[TST_index].TSTRetHandles,
                                                  &TST_TempMaxHandlesToRead,
                                                  &TST_TempMaxNumOfMatches,
                                                  TST_Workspace,
                                                  TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_IndexLookUpHandlesGet - TSTString5",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Check correct read amount */
            if (TST_TempMaxHandlesToRead != TST_ATP_IndexTestData[TST_index].TST_MaxHandlesRead3)
                TST_Status = TESTFAIL;

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"Check correct read amount",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);

      #endif

            /* Check that all handles returned are valid */
            TST_NumberOfHandleMatch = TST_ZERO;
            if (!(SST_HANDLE_COMPARE(TST_ATP_IndexTestData[TST_index].TSTRetHandles[TST_HANDLE_ONE],TST_DataHandle1))||
                !(SST_HANDLE_COMPARE(TST_ATP_IndexTestData[TST_index].TSTRetHandles[TST_HANDLE_TWO],TST_DataHandle1))||
                !(SST_HANDLE_COMPARE(TST_ATP_IndexTestData[TST_index].TSTRetHandles[TST_HANDLE_THREE],TST_DataHandle1))||
                !(SST_HANDLE_COMPARE(TST_ATP_IndexTestData[TST_index].TSTRetHandles[TST_HANDLE_FOUR],TST_DataHandle1)))
                    TST_NumberOfHandleMatch = TST_NumberOfHandleMatch+1;
            if (!(SST_HANDLE_COMPARE(TST_ATP_IndexTestData[TST_index].TSTRetHandles[TST_HANDLE_ONE],TST_DataHandle2))||
                !(SST_HANDLE_COMPARE(TST_ATP_IndexTestData[TST_index].TSTRetHandles[TST_HANDLE_TWO],TST_DataHandle2))||
                !(SST_HANDLE_COMPARE(TST_ATP_IndexTestData[TST_index].TSTRetHandles[TST_HANDLE_THREE],TST_DataHandle2))||
                !(SST_HANDLE_COMPARE(TST_ATP_IndexTestData[TST_index].TSTRetHandles[TST_HANDLE_FOUR],TST_DataHandle2)))
                TST_NumberOfHandleMatch = TST_NumberOfHandleMatch+1;
            if (!(SST_HANDLE_COMPARE(TST_ATP_IndexTestData[TST_index].TSTRetHandles[TST_HANDLE_ONE],TST_DataHandle3))||
                !(SST_HANDLE_COMPARE(TST_ATP_IndexTestData[TST_index].TSTRetHandles[TST_HANDLE_TWO],TST_DataHandle3))||
                !(SST_HANDLE_COMPARE(TST_ATP_IndexTestData[TST_index].TSTRetHandles[TST_HANDLE_THREE],TST_DataHandle3))||
                !(SST_HANDLE_COMPARE(TST_ATP_IndexTestData[TST_index].TSTRetHandles[TST_HANDLE_FOUR],TST_DataHandle3)))
                TST_NumberOfHandleMatch = TST_NumberOfHandleMatch+1;
            if (!(SST_HANDLE_COMPARE(TST_ATP_IndexTestData[TST_index].TSTRetHandles[TST_HANDLE_ONE],TST_DataHandle4))||
                !(SST_HANDLE_COMPARE(TST_ATP_IndexTestData[TST_index].TSTRetHandles[TST_HANDLE_TWO],TST_DataHandle4))||
                !(SST_HANDLE_COMPARE(TST_ATP_IndexTestData[TST_index].TSTRetHandles[TST_HANDLE_THREE],TST_DataHandle4))||
                !(SST_HANDLE_COMPARE(TST_ATP_IndexTestData[TST_index].TSTRetHandles[TST_HANDLE_FOUR],TST_DataHandle4)))
                TST_NumberOfHandleMatch = TST_NumberOfHandleMatch+1;

            if (TST_NumberOfHandleMatch != TST_4_HANDLES)
                TST_Status = TESTFAIL;        

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"Check that all handles returned are valid",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);
    

            /*End index lookup*/
            TST_Status = SST_IndexLookUpEnd (&TST_IterCookie);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_IndexLookUpEnd - TSTString2",
                                TST_ATP_IndexTestData[TST_index].TST_Name,
                                TST_MasterTestName);

      

            /* Unbind Object#3 from String#5 */
            /*-------------------------------*/
            TST_Status = SST_IndexLookupUnbind(TST_TransactionId,
                                              TST_SessionId,
                                              TST_DataHandle3,
                                              TST_ATP_IndexTestData[TST_index].TSTString5Size,
                                              TST_ATP_IndexTestData[TST_index].TSTString5,
                                              TST_Workspace,
                                              TST_WorkspaceSizeInBytes);


            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_IndexLookupUnbind - object #3 from String#5",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);
      

            /* Receive and verify all handles for TSTString5 */
            /*-----------------------------------------------------------*/
            /*Begin index lookup*/
            TST_Status = SST_IndexLookUpBegin (TST_ATP_IndexTestData[TST_index].TSTString5,
                                              TST_ATP_IndexTestData[TST_index].TSTString5Size, 
                                              &TST_IterCookie);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_IndexLookUpBegin-TSTString5",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);
      
            TST_TempMaxHandlesToRead = TST_READ_MAX_10_HANDLES; 

            TST_Status = SST_IndexLookUpHandlesGet(TST_SessionId,
                                                  &TST_IterCookie,
                                                  (SSTHandle_t*)TST_ATP_IndexTestData[TST_index].TSTRetHandles,
                                                  &TST_TempMaxHandlesToRead,
                                                  &TST_TempMaxNumOfMatches,
                                                  TST_Workspace,
                                                  TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_IndexLookUpHandlesGet - TSTString5",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Check correct read amount */
            if (TST_TempMaxHandlesToRead != TST_3_HANDLES)
                TST_Status = TESTFAIL;

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"Check correct read amount",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Check that all handles returned are valid */
            TST_NumberOfHandleMatch = TST_ZERO;
            if (!(SST_HANDLE_COMPARE(TST_ATP_IndexTestData[TST_index].TSTRetHandles[TST_HANDLE_ONE],TST_DataHandle1))||
                !(SST_HANDLE_COMPARE(TST_ATP_IndexTestData[TST_index].TSTRetHandles[TST_HANDLE_TWO],TST_DataHandle1))||
                !(SST_HANDLE_COMPARE(TST_ATP_IndexTestData[TST_index].TSTRetHandles[TST_HANDLE_THREE],TST_DataHandle1)))
                    TST_NumberOfHandleMatch = TST_NumberOfHandleMatch+1;
            if (!(SST_HANDLE_COMPARE(TST_ATP_IndexTestData[TST_index].TSTRetHandles[TST_HANDLE_ONE],TST_DataHandle2))||
                !(SST_HANDLE_COMPARE(TST_ATP_IndexTestData[TST_index].TSTRetHandles[TST_HANDLE_TWO],TST_DataHandle2))||
                !(SST_HANDLE_COMPARE(TST_ATP_IndexTestData[TST_index].TSTRetHandles[TST_HANDLE_THREE],TST_DataHandle2)))
                TST_NumberOfHandleMatch = TST_NumberOfHandleMatch+1;
            if (!(SST_HANDLE_COMPARE(TST_ATP_IndexTestData[TST_index].TSTRetHandles[TST_HANDLE_ONE],TST_DataHandle4))||
                !(SST_HANDLE_COMPARE(TST_ATP_IndexTestData[TST_index].TSTRetHandles[TST_HANDLE_TWO],TST_DataHandle4))||
                !(SST_HANDLE_COMPARE(TST_ATP_IndexTestData[TST_index].TSTRetHandles[TST_HANDLE_THREE],TST_DataHandle4)))
                TST_NumberOfHandleMatch = TST_NumberOfHandleMatch+1;

            if (TST_NumberOfHandleMatch != TST_3_HANDLES)
                TST_Status = TESTFAIL;        

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"Check that all handles returned are valid",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);
      

            /*End index lookup*/
            TST_Status = SST_IndexLookUpEnd (&TST_IterCookie);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_IndexLookUpEnd - TSTString2",
                                TST_ATP_IndexTestData[TST_index].TST_Name,
                                TST_MasterTestName);

      

            /* Delete lookup indexes */
            /*-----------------------*/
            /*Cleanup index for String#1*/
            TST_Status = SST_IndexLookupDelete(TST_TransactionId,
                                              TST_SessionId, 
                                              TST_ATP_IndexTestData[TST_index].TSTString1Size,
                                              TST_ATP_IndexTestData[TST_index].TSTString1,
                                              TST_Workspace,
                                              TST_WorkspaceSizeInBytes);


      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_IndexLookupDelete-String1",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);
      

            /*Cleanup index for String#2*/
            TST_Status = SST_IndexLookupDelete(TST_TransactionId,
                                              TST_SessionId, 
                                              TST_ATP_IndexTestData[TST_index].TSTString2Size,
                                              TST_ATP_IndexTestData[TST_index].TSTString2,
                                              TST_Workspace,
                                              TST_WorkspaceSizeInBytes);


      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_IndexLookupDelete-String2",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);
      

            /*Cleanup index for String#3*/
            TST_Status = SST_IndexLookupDelete(TST_TransactionId,
                                              TST_SessionId, 
                                              TST_ATP_IndexTestData[TST_index].TSTString3Size,
                                              TST_ATP_IndexTestData[TST_index].TSTString3,
                                              TST_Workspace,
                                              TST_WorkspaceSizeInBytes);


      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_IndexLookupDelete-String3",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);
      

            /*Cleanup index for String#4*/
            TST_Status = SST_IndexLookupDelete(TST_TransactionId,
                                              TST_SessionId, 
                                              TST_ATP_IndexTestData[TST_index].TSTString4Size,
                                              TST_ATP_IndexTestData[TST_index].TSTString4,
                                              TST_Workspace,
                                              TST_WorkspaceSizeInBytes);


      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_IndexLookupDelete-String4",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);
      

            /*Cleanup index for String#5*/
            TST_Status = SST_IndexLookupDelete(TST_TransactionId,
                                              TST_SessionId, 
                                              TST_ATP_IndexTestData[TST_index].TSTString5Size,
                                              TST_ATP_IndexTestData[TST_index].TSTString5,
                                              TST_Workspace,
                                              TST_WorkspaceSizeInBytes);


      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_IndexLookupDelete-String5",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);
      

            /* Delete all data objects */
            /*-------------------------*/
            /*DataObject#1*/
            TST_Status = SST_DataDelete(TST_TransactionId,
                                        TST_SessionId,  
                                        TST_DataHandle1,
                                        TST_Workspace,
                                        TST_WorkspaceSizeInBytes);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete - #1",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);
      

            /*DataObject#2*/
            TST_Status = SST_DataDelete(TST_TransactionId,
                                        TST_SessionId,  
                                        TST_DataHandle2,
                                        TST_Workspace,
                                        TST_WorkspaceSizeInBytes);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete - #2",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);
      

            /*DataObject#3*/
            TST_Status = SST_DataDelete(TST_TransactionId,
                                        TST_SessionId,  
                                        TST_DataHandle3,
                                        TST_Workspace,
                                        TST_WorkspaceSizeInBytes);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete - #3",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);
      

            /*DataObject#4*/
            TST_Status = SST_DataDelete(TST_TransactionId,
                                        TST_SessionId,  
                                        TST_DataHandle4,
                                        TST_Workspace,
                                        TST_WorkspaceSizeInBytes);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete - #4",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);
      

            /* Delete the authenticator */
            /*--------------------------*/
            TST_Status = SST_AuthenticatorDelete(TST_TransactionId,
                                                TST_AuthHandle);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorDelete - Master authenticator",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);
      

            /* Close the transaction */
            /*-----------------------*/
            TST_Status = SST_TransactionEnd(TST_TransactionId,
                       DX_TRUE,/*reflash sensitive*/
                       TST_Workspace,
                                           TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);  
      

            /* Delete the session */
            /*--------------------*/
            TST_Status = SST_SessionDelete(TST_SessionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionDelete",
                          TST_ATP_IndexTestData[TST_index].TST_Name,
                          TST_MasterTestName);
      

        }/*End of TST_index "for loop" */
    }/*End of TST_HandleType "for loop" */

    return TST_Status;

EXIT_ON_ERROR:
  {
    return DX_FAILURE;
  }


}/* End of SST_TST_ATP_Index */

/***************************************************************************************************************************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***************************************************************************************************************************************************************/



